//

// Fragment shader for blending transition in/out textures and background texture which is the screen shot before transition occurs. 
// Modified to fade up to and then back down from a target color
// Author: Shirley Carter, Jeff Brown
//

uniform sampler2DRect texUnit;
uniform sampler2DRect inTexUnit;
uniform sampler2DRect outTexUnit;

uniform vec4 textureRect;
uniform vec4 textureRect2;

uniform int hasTextureIn;  // 0 = no texture in, 1 = has texture in 
uniform int hasTextureOut;  // 0 = no texture in, 1 = has texture in 
uniform float inAlphaValue; 
uniform float outAlphaValue; 
uniform int isScreenRendered; // 0 - NO, 1 - YES
uniform float clearScreenR; 
uniform float clearScreenG; 
uniform float clearScreenB; 
uniform float clearScreenA; 

uniform  vec4 modulateColor;
uniform vec4 targetColor;
varying vec2 gUV;
varying vec2 gUV2; 
const float kSmallValue = 1.0e-3; 

void main(void)
{
	vec4 outputColor;
	vec4 screenTexColor;
    vec4 tColor=targetColor;
	 
	if ( isScreenRendered == 1 )
		screenTexColor = texture2DRect(texUnit, gUV);
	else 
		screenTexColor = vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA); 
		
	vec4 inTexColor = texture2DRect(inTexUnit, gUV);
	vec4 outTexColor = texture2DRect(outTexUnit, gUV2);
    
    if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w ) {
        screenTexColor = vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA);
        inTexColor = vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA);
        tColor=vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA);
    }
    
    if ( gUV2.x< textureRect2.x || gUV2.x> textureRect2.x+textureRect2.z || gUV2.y < textureRect2.y || gUV2.y > textureRect2.y+textureRect2.w ) {
        outTexColor = vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA);
        tColor=vec4(clearScreenR, clearScreenG, clearScreenB, clearScreenA);
    }
    
	vec4 blendColor;
	float temp = 1.0-inAlphaValue; 
	
	if ( hasTextureIn ==1 && hasTextureOut ==1 ) { // has both in/out handlers transitioning 
		
		// Blend in and out texture, keep in mind, none of them has been blended by transitioning alpha values yet, so, we need to use inAlphaValue
		// to blend in/out textures here first. 
		
        if(inAlphaValue<.5)
            blendColor=mix(outTexColor,tColor,inAlphaValue*2.);
        else
            blendColor=mix(tColor,inTexColor,(inAlphaValue-.5)*2.);
        outputColor = blendColor;
	}
	else if ( hasTextureIn==1 && hasTextureOut == 0 ) {// has in texture only, like when transition in a new handler or could be during transition in/out handlers, 
													   // out-handlers are done, in-handlers are still transitioning in. 
        if(inAlphaValue<.5)
            blendColor=mix(screenTexColor,tColor,inAlphaValue*2.);
        else
            blendColor=mix(tColor,inTexColor,(inAlphaValue-.5)*2.);
        outputColor = blendColor;
	}
	else if (hasTextureIn ==0 && hasTextureOut==1) { // has out texture only, like when transitioning out a handler or could be during transition in/out handlers, 
													 //in-handlers are done, out-handlers are still transitioning out. 
		
        if(outAlphaValue>.5)
            blendColor=mix(tColor,outTexColor,(outAlphaValue-.5)*2.);
        else
            blendColor=mix(screenTexColor,tColor,outAlphaValue*2.);
        outputColor = blendColor;
		
		//outputColor = outTexColor; 
	} 
	
	// clamp to 1.0 for alpha 
	outputColor.a = min(outputColor.a, 1.0); 
	
	gl_FragColor = modulateColor * outputColor;
	// gl_FragColor = vec4(0.0,0.0,1.0,1.0);
}


